#include <stdio.h>
#include "types.h"

#include "Utils.h"
#include "tests.h"


static void _PrintMenu ();


typedef struct _USER_MENU_ITEM
{
	char *Descr;
	void (*pfunc) ();
} USER_MENU_ITEM, *PUSER_MENU_ITEM;


USER_MENU_ITEM UserMenu[] =
{
	{"0-Test Regsiter read word\n", TestReadWord},
	{"1-Test Regsiter write word\n", TestWriteWord},
	{"2-Test Regsiter read byte\n", TestReadByte},
	{"3-Test Regsiter write byte\n", TestWriteByte},
	{"4-Test Read DM9000 ID\n", TestReadDM9000_ID},
	{"5-Test GPIO\n", TestGPIO},	
	{"6-Test delay operation\n", TestBdelayMilli},
	{"7-Test micro delay operation\n", TestBdelayMicro},
	{"8-Test PWM-Buzzer operation\n", TestPWMBuzzer},	
	{"9-Test 1 sec timer isr operation\n", TestTimerIsr},
	{"10-Test Uart loopback no-FIFO\n", TestUartLoopbackNoFifo},
	{"11-Test Error condition on Uart while loopback no-FIFO\n", TestUartLoopbackNoFifoGenerateError},
	{"12-Test Uart loopback - FIFO with interrupts\n", Test_UART_LoopbackFIFOIntr},
	{"13-Test RT clock\n", Test_RTC_Display_Intr},
	{"14-Test ADC on channel 0\n", Test_Adc},
	{"15-Test 8 seconds Watch-Dog timer\n", Test_WatchDog},
	{"16-Display IIC device addresses\n", Test_IIC_Probe},
	{"17-Dma in polling\n", Test_Dma_Poll},
	{"18-Dma \n", Test_Dma},			
	{NULL, NULL}
};

static void _PrintMenu ()
{
	PUSER_MENU_ITEM pMenuItem = UserMenu; 	
	while (pMenuItem->Descr != NULL)
	{
		Util_SendString (pMenuItem->Descr);
		pMenuItem ++;
	}
}

void halt_on_und();
void halt_on_pabrt();

void halt_on_und (void) __attribute__ ((interrupt ("IRQ")));
void halt_on_und()
{
	Util_Printf ("Halt on und\n");
	while (1);	
}

void halt_on_pabrt (void) __attribute__ ((interrupt ("IRQ")));
void halt_on_pabrt()
{
	Util_Printf ("Halt on pabrt\n");
	while (1);	
}

/*void halt_on_dabrt (void) __attribute__ ((interrupt ("IRQ"))); *///Yoav - Make a fix 
void halt_on_dabrt()
{
	MMU_Resolve_PTE (); /* - Yoav make a fix */	
	Util_Printf ("Halt on dabrt\n");
}

int main ()
{
	int i;
	
	
	Util_Printf ("RT-ED test platform\n");
	
/* Simulate Undefined instruction */	
//	long und[8] = {0xDEADBEEF};
//	void (*pFunc)() = (void *)und;
//	void (*pFunc1)() = (void *)0x5bb00000; //(void *)0xffff0000;
//	void (*pFunc2)() = (void *)0xffe00000; //(void *)0xffff0000;	
	
//	*(volatile *)0xffff0000 = 0xDEADBEEF;  /* Simulate Data abort */

//	*(volatile *)0x70100000 = 0xDEADBEEF;  /* Simulate Data abort */
//    pFunc ();
//	pFunc1();    
//	MMU_Table_Init_MMU ();
//	pFunc2 ();
	
/*	
	{
		U32 j;
		for (j = 0; j < 40; j ++)
		{
			*(char *)j = *(char *)(0x33f80000+j);			
		}
	}
*/	
	while (1)
	{
		_PrintMenu ();
		i = Util_GetIntNum ();
		if (UserMenu[i].pfunc)
		{
			UserMenu[i].pfunc ();
		}
	}
}

void
TestWriteWord ()
{
	unsigned long Addr;
	unsigned long Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Util_Printf ("Enter the value (prefixed by 0x for hex values...");
	Val = Util_GetIntNum ();
	
	Util_Printf ("The value 0x%x is written to address 0x%x\n", Val, Addr);
	
	*((volatile unsigned long *)Addr) = Val; 	
}


void
TestReadWord ()
{
	unsigned long Addr;
	unsigned long Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Val = *((volatile unsigned long *)Addr);	

	Util_Printf ("The value 0x%x is read from address 0x%x\n", Val, Addr);
}


void
TestReadByte ()
{
	unsigned long Addr;
	unsigned char Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Val = *((volatile unsigned char *)Addr);	

	Util_Printf ("The value 0x%x is read from address 0x%x\n", Val, Addr);
}

void
TestWriteByte ()
{
	unsigned long Addr;
	unsigned char Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Util_Printf ("Enter the value (prefixed by 0x for hex values...");
	Val = Util_GetIntNum ();
	
	Util_Printf ("The value 0x%x is written to address 0x%x\n", Val, Addr);
	
	*((volatile unsigned char *)Addr) = Val; 	
}
