#include "types.h"
#include "Utils.h"
#include "WDTRegs.h"

#define PCLK 50000000

static void WDT_Start8();
static int WDT_Stop8(void);

void Test_WatchDog(void)
{
	WDT_Start8();
}

//*************************[ Timer ]********************************
void WDT_Start8()  
{
	int divider;
	
	/* 0- factor 16, 1- factor 32, 2- factor 64, 3- factor 128 */
	/* Adjust WDT frequency and counters using WTDCON and WTCNT */ 
	
	divider = 3;
    *WTCON = ((PCLK/1000000-1)<<8)|(divider<<3);  //Watch-dog timer control register
    
    *WTCNT = 0xffff;  //Watch-dog count register

	/* Setup timer as a watchdog and start operation*/
    *WTCON = (*WTCON & ~(1<<2)) |(1<<5) | 1;    
}

//=================================================================
int WDT_Stop(void)
{
    *WTCON &= ~(1 << 5);
    return (0xffff - *WTCNT);
}
