#include "RTCRegs.h"
#include "GPIORegs.h"
#include "INTRRegs.h"
#include "INTRDefs.h"
#include "types.h"
#include "Utils.h"

static void TICK_ISR (void) __attribute__ ((interrupt ("IRQ")));

typedef struct _TIME_STAMP_RECORD {
	char cYear;
	char cMon;
	char cDate;
	char cDay;
	char cHour;									
	char cMin;
	char cSec;						
} TIME_STAMP_RECORD, *PTIME_STAMP_RECORD;

void RTC_Time_Get( PTIME_STAMP_RECORD pTimeStamp)
{
    pTimeStamp->cYear = *BCDYEAR;
    pTimeStamp->cMon  = *BCDMON;
    pTimeStamp->cDate = *BCDDATE;
    pTimeStamp->cHour = *BCDHOUR;
    pTimeStamp->cMin = *BCDMIN;
    pTimeStamp->cSec = *BCDSEC;
}


void RTC_Time_Set( void )
{
    static int RTCInitialized = 0;
    if (RTCInitialized == 1)
    	return;
	*RTCCON |= 1 ;		//RTC write enable

	*BCDYEAR = 0x05 ;		
    *BCDMON  = 0x06 ;		
    *BCDDATE = 0x19 ;			
	*BCDDAY  = 0x02 ;		
	*BCDHOUR = 0x15 ;		
    *BCDMIN  = 0x21 ;		
    *BCDSEC  = 0x30 ;		
	
	*RTCCON &= ~1 ;		//RTC write disable
	RTCInitialized = 1;
}

#define	ESC_KEY		0x1b


static void TICK_ISR(void)
{
    TIME_STAMP_RECORD recTimeStamp;
    

	if (*INTPND == (1<<8)) 
	{
		//Clearing Interrupt control
        RTC_Time_Get (&recTimeStamp);				
		*SRCPND = (1<<8);
		*INTPND = (1<<8);
	    Util_Printf( "RTC time : %04x-%02x-%02x %02x:%02x:%02x\n", 0x2000+recTimeStamp.cYear, recTimeStamp.cMon,
	                             recTimeStamp.cDate, recTimeStamp.cHour,
	                             recTimeStamp.cMin, recTimeStamp.cSec );		
	}

}


void Test_RTC_Display_Intr(void) 
{
	//clearing Ticker interrupts from spurious intterupts
	*SRCPND = (1<8);
	*INTPND = (1<<8);
	pISR_TICK = (U32)TICK_ISR;
	
	//RTC_Time_Set ();	

	/*
	    Set ticker to get tick interrupt every second.
	*/    
	*TICNT = 0xFF;
	*INTMSK &= ~(1<<8); //at Interrupt controller	
	
   	Uart_Printf( "RTC TIME-Ticker Display, press ESC key to exit !\n" ) ;
    while( Util_Getkey() != ESC_KEY );

	*TICNT &= 0x80;      //Disable ticker from requesting service.
	*INTMSK |= (1<<8); //Disable ticker interrupts on interrupt controller.	
}
