#include "types.h"
#include "Utils.h"
#include "INTRDefs.h"
#include "INTRRegs.h"
#include "Dma.h"


//#define RTE_SIM_MODE
#define	DMA_CHECK_ATTR	1

typedef struct{						//can't use __packed???
    volatile U32 DISRC;	    //0x0
    volatile U32 DISRCC;    //0x4
    volatile U32 DIDST;	    //0x8
    volatile U32 DIDSTC;    //0xc
    volatile U32 DCON;	    //0x10
    volatile U32 DSTAT;	    //0x14
    volatile U32 DCSRC;	    //0x18
    volatile U32 DCDST;	    //0x1c
    volatile U32 DMASKTRIG; //0x20
}DMAReg;

static struct{
	U16 used;
	U16 DevID;
	volatile DMAReg *pDMA;
}
DMAChannel[MAX_DMA_CHANNEL];
#ifdef RTE_SIM_MODE
DMAReg	gRTEDmgReg;
#endif

int		gNumOfDMAInterrupts;
volatile int		gIntDone = 0;
/********************************************************/
//attr��16λΪ�豸ID,��16λ�ĸ�8λΪDMA����Դ,Ŀ������(AHP/APB,INCREASE/FIX)
//��8λΪ����Դ,����ֵʧ��ΪREQUEST_DMA_FAIL,�ɹ���16λΪ�豸ID,��8λΪ���뵽��ͨ��
U32 RequestDMASW(U32 attr, U32 mode)
{
	U16 channel;
	U32 ret;
	
	attr &= ~0xff;
	mode &= ~HW_TRIG;
	
	for(channel=0; channel<(MAX_DMA_CHANNEL*0x10); channel+=0x10)
	{
		ret = RequestDMA(attr|channel, mode);
		if(ret!=REQUEST_DMA_FAIL)
			break;
	}
	return ret;			
}

U32 RequestDMA(U32 attr, U32 mode)
{
	U16 DevID, ReqSrc, ch;
	U32 ret=REQUEST_DMA_FAIL, r;
	
	DevID   = attr>>16;	
	ReqSrc  = attr&0xff;	
	
	if(((ReqSrc>>4)>=MAX_DMA_CHANNEL)||((ReqSrc&0xf)>4))
		return ret;
		
//	EnterCritical(&r);
		
	if(DMAChannel[ReqSrc>>4].used!=DMA_IS_FREE)
	{
		U8 src = ReqSrc;			
		
		if(src==REQ_IISDI)
		{		
			if(DMAChannel[2].used!=DMA_IS_FREE)
				goto RequestDmaExit;
			else							
				ReqSrc = 0x21;											
		}
		else if(src==REQ_SDI)
		{
			if(DMAChannel[2].used!=DMA_IS_FREE)
			{
				if(DMAChannel[3].used!=DMA_IS_FREE)
					goto RequestDmaExit;
				else
					ReqSrc = 0x31;				
			}
			else
				ReqSrc = 0x22;					
		}
		else if(src==REQ_SPI)
		{
			if(DMAChannel[3].used!=DMA_IS_FREE)
				goto RequestDmaExit;
			else				
				ReqSrc = 0x32;				
		}
		else if(src==REQ_TIMER)
		{
			if(DMAChannel[2].used!=DMA_IS_FREE)
			{
				if(DMAChannel[3].used!=DMA_IS_FREE)
					goto RequestDmaExit;
				else				
					ReqSrc = 0x33;				
			}
			else				
				ReqSrc = 0x23;					
		}
		else
			goto RequestDmaExit;		
	}	
			
	ch = ReqSrc>>4;
	if(mode&HW_TRIG)
		DMAChannel[ch].used  = DMA_IS_HWTRIG;
	else
		DMAChannel[ch].used  = DMA_IS_SWTRIG;	
	DMAChannel[ch].DevID = DevID;

#ifdef RTE_SIM_MODE
	DMAChannel[ch].pDMA = &gRTEDmgReg;
#else	
	DMAChannel[ch].pDMA  = (volatile DMAReg *)(0x4b000000+(ch)*0x40);	
#endif	
	DMAChannel[ch].pDMA->DMASKTRIG = 1<<2;	//stop dma
	DMAChannel[ch].pDMA->DISRCC = (attr>>8)&3;	
	DMAChannel[ch].pDMA->DIDSTC = (attr>>12)&3;	
	mode &= ~0x07000000;
	mode |= (ReqSrc&0x7)<<24;
	DMAChannel[ch].pDMA->DCON	= mode;	
	
#ifdef RTE_SIM_MODE
	Uart_Printf ("DMA->DMASKTRIG = 0x%x\n", DMAChannel[ch].pDMA->DMASKTRIG);
	Uart_Printf ("DMA->DISRCC = 0x%x\n", DMAChannel[ch].pDMA->DISRCC);
	Uart_Printf ("DMA->DIDSTC = 0x%x\n", DMAChannel[ch].pDMA->DIDSTC);
	Uart_Printf ("DMA->DCON = 0x%x\n", DMAChannel[ch].pDMA->DCON);			
#endif	

//	DbgOut("Request DMA %x success\n", ReqSrc);
	ret = (DevID<<16)|ReqSrc;
	
RequestDmaExit:
//	ExitCritical(&r);	
	return ret;			
}

U16 ReleaseDMA(U32 attr)
{
	U16 DevID, ReqSrc, ch;	
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;
	
#if	DMA_CHECK_ATTR					
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return 1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return 1;
#endif	
		
	DMAChannel[ch].pDMA->DMASKTRIG = 0;//4;	//stop dma and channel off 
	DMAChannel[ch].used = DMA_IS_FREE;
	
	return 0;					
}

U16 StartDMA(U32 attr)
{
	U16 DevID, ReqSrc, ch;	
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;		
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return 1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return 1;
#endif
	
	if(DMAChannel[ch].used==DMA_IS_HWTRIG)
		DMAChannel[ch].pDMA->DMASKTRIG = 2;		//channel on
	if(DMAChannel[ch].used==DMA_IS_SWTRIG)
		DMAChannel[ch].pDMA->DMASKTRIG = 3;		//sw_trig
		
	return 0;	
}

U16 StopDMA(U32 attr)
{
	U16 DevID, ReqSrc, ch;
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;		
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return 1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return 1;
#endif	

	DMAChannel[ch].pDMA->DMASKTRIG = 1<<2;	//channel off	
		
	return 0;
}

U16 SetDMARun(U32 attr, U32 src_addr, U32 dst_addr, U32 len)
{
	U16 DevID, ReqSrc, ch;	
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;

#ifdef RTE_SIM_MODE	
	Uart_Printf ("SetDMARun: ch = 0x%x, ReqSrc = 0x%x\n", ch, ReqSrc);		
	Uart_Printf ("SetDMARun: DMAChannel[ch].DevID = 0x%x, DevID = 0x%x\n", DMAChannel[ch].DevID, DevID);			
	Uart_Printf ("SetDMARun: DMAChannel[ch].used = 0x%x\n", DMAChannel[ch].used, DevID);				
#endif	
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return 1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return 1;
#endif
	DMAChannel[ch].pDMA->DISRC = src_addr;
	DMAChannel[ch].pDMA->DIDST = dst_addr;
	DMAChannel[ch].pDMA->DCON &= ~0xfffff;
	DMAChannel[ch].pDMA->DCON |= len&0xfffff;
	
	if(attr&DMA_START)
	{
		if(DMAChannel[ch].used==DMA_IS_HWTRIG)
			DMAChannel[ch].pDMA->DMASKTRIG = 2;		//channel on
		if(DMAChannel[ch].used==DMA_IS_SWTRIG)
			DMAChannel[ch].pDMA->DMASKTRIG = 3;		//sw_trig
	}
	
#ifdef RTE_SIM_MODE
	Uart_Printf ("DMA->DISRC = 0x%x\n", DMAChannel[ch].pDMA->DISRC);
	Uart_Printf ("DMA->DIDST = 0x%x\n", DMAChannel[ch].pDMA->DIDST);
	Uart_Printf ("DMA->DCON = 0x%x\n", DMAChannel[ch].pDMA->DCON);			
	Uart_Printf ("DMA->DMASKTRIG = 0x%x\n", DMAChannel[ch].pDMA->DMASKTRIG);	
#endif
	
	return 0;
}

U32 QueryDMAStat(U32 attr)
{
	U16 DevID, ReqSrc, ch;
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;		
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return -1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return -1;
#endif	

	return DMAChannel[ch].pDMA->DSTAT;	//STAT[21:20], CURR_TC[19:0] 
}

volatile U32 QueryDMASrc(U32 attr)
{
	U16 DevID, ReqSrc, ch;
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;		
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return -1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return -1;
#endif	

	return (volatile U32)(DMAChannel[ch].pDMA->DCSRC);
}

U32 QueryDMADst(U32 attr)
{
	U16 DevID, ReqSrc, ch;
	
	DevID  = attr>>16;
	ReqSrc = attr&0xf;
	ch     = (attr&0xf0)>>4;		
#if	DMA_CHECK_ATTR		
	if((ch>=MAX_DMA_CHANNEL)||(ReqSrc>4))
		return -1;
	if((DMAChannel[ch].used==DMA_IS_FREE)||(DMAChannel[ch].DevID!=DevID))
		return -1;
#endif	

	return DMAChannel[ch].pDMA->DCDST;
}


#define	AUDIO_PLAY_DEV	0x100
#define	AUDIO_REC_DEV	0x101

#define LOCAL_MEM_DEV	0x100

#define	LOCAL_MEM_DMA_ATTR	((LOCAL_MEM_DEV<<16)|SRC_LOC_AHB|SRC_ADDR_INC|DST_LOC_AHB|DST_ADDR_INC|REQ_XDREQ0)
#define	LOCAL_MEM_DMA_MODE	(HANDSHAKE_MODE|SYNC_AHB|DONE_GEN_INT|TSZ_BURST|WHOLE_SVC|SW_TRIG|RELOAD_OFF|DSZ_32b)

static void PlayDMA0Done (void) __attribute__ ((interrupt ("IRQ")));

static void PlayDMA0Done(void)
{
	U32 r;
//	EnterCritical(&r);
//    ClearPending(BIT_DMA0);     //Clear pending bit
    gIntDone = 1;	
    gNumOfDMAInterrupts ++;
    
	*SRCPND = BIT_DMA0;
	*INTPND = BIT_DMA0;
    
//	ExitCritical(&r);    
}

void Test_Dma (void)
{
	int i;
	gNumOfDMAInterrupts	= 0;
    pISR_DMA0 = (U32)PlayDMA0Done;
	*INTMSK	 &= ~(BIT_DMA0);    	
//	EnableIrq (BIT_DMA0);
	for (i = 0; i < 10; i ++)
	{
		RequestDMASW (LOCAL_MEM_DMA_ATTR, LOCAL_MEM_DMA_MODE);
		SetDMARun (LOCAL_MEM_DMA_ATTR|DMA_START, 0x34400000, 0x34500000, 0x10000); /* See calculation of size from spec */
		while (gIntDone == 0);
		gIntDone = 0;
	}		
	*INTMSK	 |= (BIT_DMA0);	
//	DisableIrq (BIT_DMA0);
//	MMU_InvalidateDCacheMVA (0x34500000);
	Uart_Printf ("\nNum of DMA interrupts is 0x%x\n", gNumOfDMAInterrupts);	
}

void Test_Dma_Poll (void)
{
	int i;
	for (i = 0; i < 10; i ++)
	{
		RequestDMASW (LOCAL_MEM_DMA_ATTR, LOCAL_MEM_DMA_MODE);
		SetDMARun (LOCAL_MEM_DMA_ATTR|DMA_START, 0x34400000, 0x34500000, 0x100);
		while (QueryDMAStat (LOCAL_MEM_DMA_ATTR) != 0);
//		MMU_InvalidateDCacheMVA (0x34500000);
	}		
}


void Test_Memcpy (void)
{
	int i;
	int j;
	volatile char *dst;
	volatile char *src;
	
	for (i = 0; i < 1000; i ++)
	{
		dst = (volatile char *)0x34400000;
		src = (volatile char *)0x34500000;
		for (j = 0; j < 0x40000; j ++)
		{
			*dst ++ = *src ++;
		}
	}
}
