#include "types.h"
#include "Utils.h"
#include "ADCRegs.h"

#define ADC_FREQ 2500000
#define PCLK 50000000

#define	ESC_KEY		0x1b

//==================================================================================		
int ReadAdc0()
{
	/*
		Now - issue the start command.
	*/
    *ADCCON|=0x1;   //start ADC


detect_conversion:

    while(*ADCCON & 0x1);	//Wait until Enable_start bit has returned to low
    
    while(!(*ADCCON & 0x8000));	//Wait until EC(End of Conversion) flag is high

    return ( (int)*ADCDAT0 & 0x3ff ); // Read the data
}

//==================================================================================
void Test_Adc(void) 
{
    volatile int a0;
	volatile U32 preScaler;     
    U32 rADCCON_save = *ADCCON;
    
   	Util_Printf( "ADC INPUT Test, press ESC key to exit !\n" ) ;

    /*
     * Set prescaler value to reflect smapling frequency of 500000 SPS
    */ 
    preScaler = (PCLK/ADC_FREQ);               
    
    Util_Printf("Sampling rate is set to %d SPS\n",(PCLK/preScaler)/5);
    
    /*
    * Setup channel 0
    */
	*ADCCON = (1<<14)|(preScaler<<6);
	    
    while( Util_Getkey() != ESC_KEY )
    {
	    a0=ReadAdc0();

	    Util_Printf( "AIN0: %04d\n", a0 );
    }
   
    *ADCCON = rADCCON_save;
    Util_Printf("\nrADCCON = 0x%x\n", *ADCCON);
}
