#include <stdio.h>
#include "types.h"

#include "Utils.h"
#include "tests.h"


static void _PrintMenu ();


typedef struct _USER_MENU_ITEM
{
	char *Descr;
	void (*pfunc) ();
} USER_MENU_ITEM, *PUSER_MENU_ITEM;


USER_MENU_ITEM UserMenu[] =
{
	{"0-Test Regsiter read word\n", TestReadWord},
	{"1-Test Regsiter write word\n", TestWriteWord},
	{"2-Test Regsiter read byte\n", TestReadByte},
	{"3-Test Regsiter write byte\n", TestWriteByte},
	{"4-Test Read DM9000 ID\n", TestReadDM9000_ID},
	{"5-Test GPIO\n", TestGPIO},	
	{"6-Test delay operation\n", TestBdelayMilli},
	{"7-Test micro delay operation\n", TestBdelayMicro},
	{"8-Test PWM-Buzzer operation\n", TestPWMBuzzer},	
	{"9-Test 1 sec timer isr operation\n", TestTimerIsr},
	{"10-Set IP address, subnet and gateway\n", SetIP},
	{"11-Ping to a specified IP address\n", TestPing},								
	{"12-Issue Ping server\n", TestPingServer},												
					
	{NULL, NULL}
};

static void _PrintMenu ()
{
	PUSER_MENU_ITEM pMenuItem = UserMenu; 	
	while (pMenuItem->Descr != NULL)
	{
		Util_SendString (pMenuItem->Descr);
		pMenuItem ++;
	}
}

int main ()
{
	int i;
	Util_Printf ("RT-ED test platform\n");
	
	MMU_Table_Init_MMU ();	
	
	while (1)
	{
		_PrintMenu ();		
		i = Util_GetIntNum ();
		if (UserMenu[i].pfunc)
		{
			UserMenu[i].pfunc ();
		}
	}
}

void
TestWriteWord ()
{
	unsigned long Addr;
	unsigned long Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Util_Printf ("Enter the value (prefixed by 0x for hex values...");
	Val = Util_GetIntNum ();
	
	Util_Printf ("The value 0x%x is written to address 0x%x\n", Val, Addr);
	
	*((volatile unsigned long *)Addr) = Val; 	
}


void
TestReadWord ()
{
	unsigned long Addr;
	unsigned long Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Val = *((volatile unsigned long *)Addr);	

	Util_Printf ("The value 0x%x is read from address 0x%x\n", Val, Addr);
}


void
TestReadByte ()
{
	unsigned long Addr;
	unsigned char Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Val = *((volatile unsigned char *)Addr);	

	Util_Printf ("The value 0x%x is read from address 0x%x\n", Val, Addr);
}

void
TestWriteByte ()
{
	unsigned long Addr;
	unsigned char Val;	

	Util_Printf ("Enter the address (prefixed by 0x for hex values...");	
	Addr = Util_GetIntNum ();
	Util_Printf ("Enter the value (prefixed by 0x for hex values...");
	Val = Util_GetIntNum ();
	
	Util_Printf ("The value 0x%x is written to address 0x%x\n", Val, Addr);
	
	*((volatile unsigned char *)Addr) = Val; 	
}
